/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class TagUtils {
    public static Object unwrap(@Nullable Tag t) {
        if (t == null || t instanceof EndTag) {
            return null;
        }
        if (t instanceof StringTag) {
            return t.m_7916_();
        }
        if (t instanceof NumericTag) {
            return ((NumericTag)t).m_8103_();
        }
        return t;
    }

    public static Tag wrap(@Nullable Object o) {
        if (o instanceof Tag) {
            return (Tag)o;
        }
        if (o instanceof Number) {
            return DoubleTag.m_128500_((double)((Number)o).doubleValue());
        }
        if (o instanceof CharSequence) {
            return StringTag.m_129297_((String)o.toString());
        }
        return null;
    }

    public static JsonElement toJson(@Nullable Tag t) {
        if (t == null || t instanceof EndTag) {
            return JsonNull.INSTANCE;
        }
        if (t instanceof StringTag) {
            return new JsonPrimitive(t.m_7916_());
        }
        if (t instanceof NumericTag) {
            return new JsonPrimitive(((NumericTag)t).m_8103_());
        }
        if (t instanceof CollectionTag) {
            CollectionTag l = (CollectionTag)t;
            JsonArray array = new JsonArray();
            for (Tag tag : l) {
                array.add(TagUtils.toJson(tag));
            }
            return array;
        }
        if (t instanceof CompoundTag) {
            CompoundTag c = (CompoundTag)t;
            JsonObject object = new JsonObject();
            for (String key : c.m_128431_()) {
                object.add(key, TagUtils.toJson(c.m_128423_(key)));
            }
            return object;
        }
        return JsonNull.INSTANCE;
    }
}

